/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues;

import fuzs.armorstatues.ArmorStatues;
import fuzs.armorstatues.api.StatuesApi;
import fuzs.armorstatues.data.ModLanguageProvider;
import fuzs.armorstatues.handler.ArmorStandInteractHandler;
import fuzs.puzzleslib.core.CoreServices;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="armorstatues")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ArmorStatuesForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("armorstatues").accept(new StatuesApi());
        CoreServices.FACTORIES.modConstructor("armorstatues").accept(new ArmorStatues());
        ArmorStatuesForge.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, evt -> ArmorStandInteractHandler.onUseEntityAt(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getTarget(), evt.getLocalPos()).ifPresent(result -> {
            evt.setCancellationResult(result);
            evt.setCanceled(true);
        }));
        MinecraftForge.EVENT_BUS.addListener(evt -> ArmorStandInteractHandler.onPlayerLoggedIn((ServerPlayer)evt.getEntity()));
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModLanguageProvider(generator, "statues"));
    }
}

